%% Version 2
format short g;
v0 = FR(1).*1e-3.*(1/60); % convert flow rate from ml to L and H to min

FA0 = conc_mon.*v0; % mol/L * L/s = mol/s

CONV_INST = conversionvec/100;
[len wid] = size(CONV_INST);
TOTAL_CONV = zeros(len,1);

for j = 2:wid
    TOTAL_CONV(:,j) =  TOTAL_CONV(:,j-1)+CONV_INST(:,j); 
end

Vspan = linspace(0,reactor_volume,wid);

kiguess = 0.01;
kpguess = 0.4;
y0 = [kiguess kpguess];

opts = statset('nlinfit');
%opts.RobustWgtFun = 'andrews'; % default weight function

for i = 1:len
    dXdV =  CONV_INST(i,:)./(reactor_volume./wid);
    
    Parameters = [TOTAL_CONV(i,:) ; Vspan];
    [RateConsts,R,J,CovB,MSE,ErrorModelInfo] = nlinfit(Parameters, dXdV, @(y0, par) fitfun(y0,par,conc_mon(i),conc_cat(i),FA0(i),Vspan,v0),y0,opts);
    
    ki(i) = RateConsts(1);
    kp(i) = RateConsts(2);
end 

ki
kp
%%

Conc_Hex = [];

for z = 1:len
    for i = 1:10
        if i == 1
            Conc_Hex(z,i) = MF_hex_exp(z)
        elseif i > 1
            z
            i
            Conc_Hex(z,i) = Conc_Hex(z,i-1) - MF_hex_exp(z)*(MF_hex_exp(z).*conversionvec(z,i-1));
            if Conc_Hex(z,i) < 0
                Conc_Hex(z,i) = 0
            end
        end
    end
end

Conc_Hex = Conc_Hex/3600; %hr to min

plot(Vspan,Conc_Hex')
title('[Hex] based on conversion')
xlabel('Volume (L)')
ylabel('Concentration (M)');

%% Functions
function dXdV = fitfun(y0,par,conc_mon,conc_cat,FA0,Vspan,v0)
    ki = y0(1);
    kp = y0(2);
    c0 = [conc_mon, 0, conc_cat]; % CB0 init concentration of Cat + CoCat complex
    C_Hex = conc_mon.*(1-par(1,:));
    [V y] = ode15s(@(V,y) dCdV(V,y,ki,kp,v0),Vspan,c0);
    rA = kp.*C_Hex'.*y(:,2)+ki.*C_Hex'.*y(:,3);
    dXdV = [rA./FA0]';
end

function odevec = dCdV(~,variables,ki,kp,v0)
kd = 0.1; % death rate constant guess
ktr = 1; % transfer rate
C_Hex = variables(1); % [Hex]
C_ZrHex = variables(2); % Activated Catalyst
C_ZrCo = variables(3); % Inactive Catalyst complex
rA = -(kp.*C_ZrHex.*C_Hex+ki.*C_Hex.*C_ZrCo+ktr.*C_ZrHex.*C_Hex); % rate of Hex prod
rB = ki.*C_ZrCo.*C_Hex-kd.*C_ZrHex; % rate of activated catalyst prod
rC = -(ki.*C_ZrCo.*C_Hex); % rate of inactive catalyst
dC_HexdV = rA/v0;
dC_ZrHexdV = rB/v0;
dC_ZrCodV = rC/v0;
odevec = [dC_HexdV; dC_ZrHexdV; dC_ZrCodV];
end
